#ifndef __xhandler
#define __xhandler

// also see solver.h

struct solver;

struct xhandler {
  virtual void operator() (solver& s, float& x, float& dx) = 0;
  virtual ~xhandler () {}
};

struct atmin: xhandler {
  void operator() (solver& s, float& x, float& dx);
};

struct tomax: xhandler {
	void operator() (solver& s, float& x, float& dx);
};

struct atmax: xhandler {
  void operator() (solver& s, float& x, float& dx);
};

struct tomin: xhandler {
  void operator() (solver& s, float& x, float& dx);
};

struct loopmin : tomax {
  void operator() (solver& s, float& x, float& dx);
};

struct loopmax : tomin {
  void operator() (solver& s, float& x, float& dx);
};

struct pongmax: atmax {
  void operator() (solver& s, float& x, float& dx);
};

struct pongmin: atmin {
  void operator() (solver& s, float& x, float& dx);
};

struct curve_editor;

struct gotog : xhandler {
  float g;
  curve_editor* ed;
  gotog (float gg, curve_editor* e); 
  void operator() (solver& s, float& x, float& dx);
  void set (float gg);
};

extern atmin _atmin;
extern tomax _tomax;
extern atmax _atmax;
extern tomin _tomin;

extern loopmin _loopmin;
extern loopmax _loopmax;
extern pongmin _pongmin;
extern pongmax _pongmax;
extern gotog _gotog;

#endif
