#include "solver.h"
#include "curve_editor.h"

float excess (float x2, float x1, float delta) {
  float xd = x2 - x1;
  float d = xd / delta;
  int i = d;
  return (d - i) * delta;
}

void tomin::operator() (solver& s, float& x, float& dx) {
  float dfirst = excess (x, s.lastx, s.deltax);
  x = s.firstx + dfirst;
  s.findseg (x);
}

void tomax::operator() (solver& s, float& x, float& dx) {
  float dlast = excess (s.firstx, x, s.deltax);
  x = s.lastx - dlast;
  s.findseg (x);
}

void atmin::operator() (solver& s, float& x, float& dx) {
  x = s.firstx;
  s.setseg (0, 0);
}

void atmax::operator () (solver& s, float& x, float& dx) {
  x = s.lastx;
  s.setseg (s.last_curv, s.lastseg (s.last_curv));
}

void loopmin::operator() (solver& s, float& x, float& dx) {
  tomax::operator() (s, x, dx);
}

void loopmax::operator() (solver& s, float& x, float& dx) {
  tomin::operator() (s, x, dx);
}

void pongmax::operator () (solver& s, float& x, float& dx) {
  float over = excess (x, s.lastx, s.deltax);
  x = s.lastx - over;
  if (dx > 0) dx = -dx;
}

void pongmin::operator () (solver& s, float& x, float& dx) {
  float under = excess (s.firstx, x, s.deltax);
  x = s.firstx + under;
  if (dx < 0) dx = -dx;
}

struct curve_editor;
gotog::gotog (float gg, curve_editor* e) : ed (e) {
  set (gg);
}

void gotog::set (float gg) {
  g = gg;
  ed->update_sustain (g);
}

void gotog::operator () (solver& s, float& x, float& dx) {
  x = g;
  if (!s.findseg (x)) {
    x = s.lastx;
    set (x);
  }
}
