/*
* tap_bpm.cc
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/


#include "chrono.h"
#include "input.h"
#include "tap_bpm.h"

extern ui_clock ui_clk;

tap_display::tap_display (int sz) {
  set_extents (0, 0, sz, sz);
  lmb_clicked = 0;
  light = 0;
  tapt = 0.0f;
}

int tap_display::handle_input () {
  int r = widget::handle_input ();
  if (hover) {
    if (keypressed (SDLK_RETURN)) calc_bpm ();
    if (lmb) {
      if (lmb_clicked == 0) {
        calc_bpm ();
        lmb_clicked = 1;
      }
    } else lmb_clicked = 0;
  } 
  return r;
}

void tap_display::calc_bpm () {
  float now = ui_clk ();
  float dt = now - tapt;
  tapt = now;
  bpm = 60.0 / dt;
  if (lis) lis->changed (*this);
  light = 1;
}

void tap_display::draw () {
  widget::draw_bbox ();
  if (light) {
    glRecti (inner.left, inner.bottom, inner.right, inner.top);
    light = 0;
  }
}

void tap_display::set_listener (change_listener<tap_display>* l) {
  lis = l;
}

void tap_display::set_pos (int x, int y) {
  widget::set_pos (x, y);
  box<int>& e = extents; 
  static const float gutter = 0.5;
  int dw = gutter * e.width, dh = gutter * e.height;
  inner (e.midx - dw, e.midy - dh, e.midx + dw, e.midy + dh);
}
