#ifndef __RECTIME__
#define __RECTIME__

struct rectime {

  double dsecs;
  int mins;
  int secs;

  rectime () {
    dsecs = 0;
    mins = 0;
    secs = 0;
  }

  rectime& operator+= (double dt) {
    dsecs += dt;
    if (dsecs >= 1.) {
      dsecs -= 1.;
      ++secs;
      if (secs >= 60) {
        secs = 0;
        ++mins;
      }
    }
    return *this;
  }

  void reset () {
    dsecs = 0;
    mins = secs = 0;
  }

};

#endif
