/*
* recorder.h
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __RECORDER
#define __RECORDER

#include "rectime.h"

#include <string>
#include <list>
#include <fstream>

struct checkbutton;

struct recorder {

  std::string folder;
  std::string fname;
  std::ofstream file; 

  std::list <float*> recording;
  std::list<float*>::iterator iter, jter;
  int recording_size;
  float* samples_buffer;

  int saved;
  int saving_started;

  float nmin, nmax;
  void normalise ();

  int fps, ips; // save (and restore) <- to throttle for fast save
  void start_saving ();
  int save_some (checkbutton& cb);

  rectime rec_time_add, rec_time_save;

  recorder ();

  void add (
    float* sample_buffer, 
    int sample_buffer_size, int num_samples, 
    checkbutton& cb_record1, 
    checkbutton& cb_record2
  );

  int exists () {return recording_size;}

  void set_fname (const std::string& _fname);

  int stop_rec, stop_mins, stop_secs;
  void set_stop_at (int mins, int secs);

  void clear ();
  void start ();
  void stop ();

  ~recorder ();

};

extern recorder recorder0;

#endif
