/*
* polyrhythm.cc
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* For more information, please visit https://dinisnoise.org/
*/


#include "polyrhythm.h"
#include "vector2d.h"
#include "ui_list.h"

#include <vector>
using namespace std;

extern ui_list uis;

polyrhythm::polyrhythm () {
  name = "Poly Rhythm";
}

polyrhythm::~polyrhythm () {
  widget_save ("d_polyrhythm", ctrls);
}

void polyrhythm::setup () {

  plugin::setup ();

  n.set_text ("6 8");
  n.change_lsnr = this;

  in.set_text ("in");

  m.set_text ("8");
  m.change_lsnr = this;

  n.expr = m.expr = 0;

  cpy.set_text ("Apply to Copy curve");
  cpy.set_listener (this);

  widget* w[] = {&n, &in, &m, &cpy};
  for (int i = 0; i < 4; ++i) ctrls.push_back (w[i]);
  num_ctrls = ctrls.size ();

  widget_load ("d_polyrhythm", ctrls);

  render ();

}

void polyrhythm::render () {
  str2vec (n.text, Ns);
  M = m; 
  static const float FAC = 10000;
  static const float ELBOW = 0.1;
  pat.clear ();
  pat[0] = 1;
  for (int i = 0, j = Ns.size (); i < j; ++i) {
    int b = Ns[i];
    float dp = M * 1.0f / b;
    float p = dp;
    for (int s = 1; s < b; ++s, p += dp) {
      pat [p*FAC] = 1;
      float q = p - ELBOW;
      pat [q*FAC] = 0;
      pat [(q-ELBOW)*FAC]=0;
    }
  }
  pat[M*FAC] = 1;
  float q = M - ELBOW;
  pat[q*FAC] = 0;
  pat[(q-ELBOW)*FAC] = 0;
  points.clear ();
  for (std::map<int, int>::iterator i = pat.begin (), j = pat.end (); i != j; ++i) {
    pair<int, int> p = *i;
    points.push_back (point<float>(p.first * 1.0f / FAC, p.second));
  }
  gen_pts ();
  shapeform = 0;
}

void polyrhythm::changed (checkbutton& cb) {
  tocopy = cb.state;
}
