/*
* phrasor.cc
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/


#include "phrasor.h"
#include "dingl.h"

void phrasor::draw (box<int>& win) {
  int i;
  if (size) {
    if (state == phrasor::recording) {
      i = 0; 
    } else {
      i = cur;
    }
    draw_marker (data[i].x, data[i].y, win);
  }
}

void phrasor::draw_marker (int x, int y, box<int>& win) {
  int mk [8];
  mk[0]=win.left; 
  mk[1]=y;
  mk[2]=win.right; 
  mk[3]=y;
  mk[4]=x;
  mk[5]=win.top;
  mk[6]=x;
  mk[7]=win.bottom;
  glColor3f (0.7f, 0.7f, 0.3f);
  glVertexPointer (2, GL_INT, 0, mk);
  glDrawArrays (GL_LINES, 0, 4);
}

int phrasor::next () {
  int c = cur + 1;
  if (c >= size) {
    cur = 0; 
  } else cur = c;
  amount = cur * last_1;
  return 1;
}

int phrasor::validate () {
  size = data.size ();
  if (size == 0) return 0;
  last = size - 1;
  last_1 = 1.0f / last;
  return 1;
}


void phrasor::set_cur (float amt) {
  if (size) {
    amount = amt;
    cur = amount * last;
  }
}
