/*
* palet.h
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __bpm_palet
#define __bpm_palet

#include "arrow_button.h"
#include "item_list.h"
#include "spinner2.h"

#include <vector>


struct bpmratiot {
  int n, d;
  float r;
  bpmratiot (int nn = 2, int dd = 1);
};

struct bpmratiopairt {
  bpmratiot r[2]; 
  string lbl;
  bpmratiopairt (bpmratiot b0, bpmratiot b1);
};

struct palet : widget, click_listener, selection_listener, change_listener<field>, state_listener {

  arrow_button fold;
  int folded;

  checkbutton loop, pong;
  button rev, scrub;

  static bpmratiopairt ratios [];
  int r;
  float operator[] (int rr);
  label title;

  spinner2<float> bpm;
  std::vector<button*> bpms;
  float lastbpm;
  void setbpm (float v);

  button halv, doubl;
  void calc_halv_doubl ();
  item_list il;

  void build (float ib);
  void setup ();
  void update ();
  int handle_input ();
  void draw ();
  void clicked (button& b);
  void changed (field& f);
  void changed (checkbutton& cb);
  void selected (item_list& il, int w);

  palet ();
  ~palet ();

};

#endif
