/*
* main.h
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __MAIN
#define __MAIN

#include <string>

#define ENDER -1
#define LAUNCHLATER 1

struct instrument;
struct ui;

enum {DONT, IMMEDIATE, SOON}; 
extern int quit;
void try_quit ();

void setup_video_mode (int w, int h, int vw, int vh, int fs = 0);

void start_octave_shift (instrument* instr, int idir, const std::string& sdir);
void do_octave_shift ();
int abort_octave_shift (instrument* instr);
int esc_octave_shift (instrument *instr);
void modulate_up ();
void modulate_down ();

void set_tonic (instrument* instr, float f);
float get_tonic (instrument* instr);
void set_num_octaves (int);

enum {NUMERIC, WESTERN, INDIAN};
void set_notation (int what);
int find_nearest_note (std::string& nn, float& frequency, float& dist);

void set_current_instrument ();
instrument* set_current_instrument (const std::string& inst);
instrument* get_current_instrument ();
void load_instrument (instrument* inst = 0);
void goto_next_instrument ();
int is_instrument (ui* u);

int hide_menu ();
void show_menu ();

void applyfx (float* out0, float* out1, int delay = 1, int compress = 1);

extern int UI_OFF; 
void turn_on_ui ();
void turn_off_ui ();
void set_window_caption ();
void make_app_name ();
void make_good_name (std::string& name);
void nagscr ();

void warp_mouse (int x, int y);

int is_din_binaural ();
float get_binaural_separation_in_hz ();

void hz2step (float& hz, float& step);
void step2hz (float& step, float& hz);

extern int BPM_ID;
extern float BPM_MULT, EXTRA_BPM_MULT;
float get_bpm_mult ();

void setup_plugin_labels ();

#endif
