/*
* listeners.cc
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/


#include "microtonal-keyboard.h"
#include "listeners.h"
#include "beat2value.h"
#include "delay.h"
#include "keyboard_keyboard.h"
#include "mondrian.h"
#include "fft.h"
#include "ui_list.h"
#include "main.h"
#include "subdiv.h"

void curve_listener::edited (curve_editor* ed, int i) {
  ed->render_curve_samples ();
  curve_info& ci = ed->curveinfo[i];
  multi_curve* crv = ci.curve;
  ed->hlabel_only = crv->shapeform;
  if (ci.mix.num_vertices) ci.mix.clear ();
}

void wave_listener::edited (curve_editor* ed, int i) {
  curve_info& ci = ed->curveinfo [i];
  multi_curve& mix = ci.mix;
  switch (which) {
    case MICROTONAL_KEYBOARD:
      mkb.wavsol.update ();
      if (mix.num_vertices) mkb.wavplay.set_mix (mix, "microtonal-keyboard-waveform");
      break;
    case KEYBOARD_KEYBOARD:
      keybd2.update_waveform (mix);
      break;
    case DRONE:
      mkb.update_drone_solvers (mix);
      break;
    case MONDRIAN:
      mondrian0.update_waveform (mix);
  }
  uis.dofft ();
  curve_listener::edited (ed, i);
}

beat2value_listener::beat2value_listener () : bv (0) {}

void beat2value_listener::edited (curve_editor* ed, int i) {
  bv->sol.update ();
  curve_info& ci = ed->curveinfo [i];
  multi_curve& mix = ci.mix;
  if (mix.num_vertices) bv->set_mix (mix, "beat2value");
  curve_listener::edited (ed, i);
  subdiv_.dirty = 1;
}

void drone_mod_lis::edited (curve_editor* ed, int i) {
  curve_info& ci = ed->curveinfo [i];
  multi_curve& mix = ci.mix;
  mkb.update_drone_mod_solvers (i, mix);
  curve_listener::edited (ed, i);
}

void morse_code_listener::edited (curve_editor* ed, int i) {}

void delay_listener::edited (curve_editor* ed, int i) {
  sol->update ();
  float dx = 1.0f / (dly->nsamples - 1), x = -dx;
  (*sol)(x, dx, dly->nsamples, result);
}

void attack_listener::edited (curve_editor* ed, int i) {
  inst->update_attack ();
}

void decay_listener::edited (curve_editor* ed, int i) {
  inst->update_decay ();
}

void velocity_listener::edited (curve_editor* ed, int i) {
  keybd2.velsol.update ();
}
