/*
* delay.h
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __delay
#define __delay

#include "multi_curve.h"
#include "solver.h"
#include "listeners.h"

struct delay { // 1 channel delay

  float beats, bps;
  float msecs;

  int nsamples;
  int maxsamples; 
  float* samples;
  int id;

  float* fbk;
  float* vol;

  // feedback and volume are beziers solved into fbk and vol
  std::string fbk_fname, vol_fname;
  multi_curve fbk_crv, vol_crv;
  delay_listener fbk_lis, vol_lis;
  solver fbk_sol, vol_sol;

  delay (const std::string& fn, const std::string& vn);
  ~delay ();

  void zero ();

  void prep ();

  void set (float nbeats, float bps);
  void set (float nbeats);
  void get (float& nbeats, float& bps);

  void operator() (float* out, int nz, float fdr);

};

extern delay left_delay, right_delay;

#endif
