/*
* crvpt.h
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __crvpt__
#define __crvpt__

struct crvpt { // curve point

  float x, y;
  float t; // bezier param or segment length

  // used by solver (see solver.h/solver.cc)
  float m; // slope of seg joining next point
  int inf; // is slope infinity?

  crvpt () {
    x = y = t = m = 0;
    inf = 0;
  }

  crvpt (float xx, float yy, float tt) {
    x = xx; y = yy; t = tt;
    m = 0; inf = 0;
  }

};

#endif
