/*
* beat2value.h
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __BEAT2VALUE

#define __BEAT2VALUE

#include "curve_mixer.h"
#include "solver.h"
#include "mouse_slider.h"

#include <string>

struct beat2value : set_mixer, mouse_slider_listener {

  std::string name; 

  std::string crvname;
  multi_curve *crv;
  int crv_made_here;

  solver sol;

  xhandler *xmin, *xmax;
  enum {LOOP, PONG};
  int style;
  void setstyle (int s);

  float bps;
  float min_bpm;
  float bpm;
  float set_bpm (float n, int delta_mult = 1);
  float get_bpm ();

  float now, now2;
  float delta;
  void reverse ();

  int scrub;

  curve_mixer mixer;
  void set_mix (multi_curve& crv, const std::string& nam);

  beat2value ();
  beat2value (const std::string& crvname, const std::string& fcrvname);
  ~beat2value ();

  void setup (int nsamples = 1);

  int gen_and_mix (float* soln, float* mixb, float* mixa, int n);
  int swing_and_mix (float* soln, float* mixb, float* mixa, int n);

  int modulate_and_mix (float* in, float* mixb, float* mixa, int n, float depth); 
  int modulate_and_mix (float* in, float* mixb, float* mixa, int n, float* depth); 

  void moused (int dir, double scl);
  void after_slide ();


};

extern float BPM_MULT;
void powbeat (const std::string& name, beat2value& bv, float p);

#endif
