/*
* beat2value.cc
* DIN Is Noise is copyright (c) 2006-2026 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#include "beat2value.h"
#include "utils.h"
#include "console.h"
#include "audio.h"

#include <string>
#include <algorithm>

using namespace std;

extern int SAMPLE_RATE;

beat2value::~beat2value () {
  if (crv_made_here) {
    crv->save (crvname);
    delete crv;
  }
}

beat2value::beat2value (const string& n, const string& c) : name (n), crvname (c)  { 
  crv = new multi_curve (c);
  crv_made_here = 1;
  setup (); 
}

beat2value::beat2value () { 
  crv_made_here = 0; 
  crv = 0;
}

void beat2value::setup (int delta_mult) {
  min_bpm = 0;
  bpm = 60;
  delta = 0;
  set_bpm (bpm, delta_mult);
  setstyle (LOOP);
  sol (crv);
  now = sol.firstx;
  scrub = 0;
}

void beat2value::reverse () {
  delta = -delta;
  if (style == LOOP) {
    if (delta < 0) {
      xmin = &_tomax;
      xmax = &_tomin;
    } else {
      xmax = &_tomin;
      xmin = &_tomax;
    }
  } /* else {
    // nothing todo for pong
  }*/
}

int beat2value::swing_and_mix (float* soln, float* mixb, float* mixa, int n) {
  now = soln [n-1];
  if (mixer.active) {
    mixer.swing_mix (soln, mixb, n, *xmin, *xmax);
    sol (soln, n);
    mixer.do_mix (soln, mixb, mixa, n);
  } else
    sol (soln, n);
  return mixer.active;
}


int beat2value::gen_and_mix (float* soln, float* mixb, float* mixa, int n) {

  if (scrub) {

    if (scrub == 2) {
      fill (soln, now, now2, n);
      sol (soln, n, now, *xmin, *xmax);
      scrub = 1;
    } else {
      for (int i = 0; i < n; ++i) soln[i] = now;
      sol (soln, n, now, *xmin, *xmax);
    }

  } else {
    sol (now, delta, n, soln, *xmin, *xmax);
  }

  if (mixer.active) {
    mixer.gen_mix (mixb, n, *xmin, *xmax);
    mixer.do_mix (soln, mixb, mixa, n);
  }

  return mixer.active;

}

int beat2value::modulate_and_mix (float* in, float* mixb, float* mixa, int n, float depth) {
  sol (now, delta, n, in, *xmin, *xmax);
  multiply (in, n, depth);
  if (mixer.active) {
    mixer.gen_mix (mixb, n, *xmin, *xmax);
    multiply (mixb, n, depth);
    mixer.do_mix (in, mixb, mixa, n);
  }
  return mixer.active;
}

int beat2value::modulate_and_mix (float* in, float* mixb, float* mixa, int n, float* depth) {
  sol (now, delta, n, in, *xmin, *xmax);
  multiply (in, depth, n);
  if (mixer.active) {
    mixer.gen_mix (mixb, n, *xmin, *xmax);
    multiply (mixb, depth, n);
    mixer.do_mix (in, mixb, mixa, n);
  }
  return mixer.active;
}


float beat2value::set_bpm (float n, int nsamples) {

  if (n < min_bpm) n = min_bpm;

  bpm = n;
  bps = bpm / 60.0f; 
    
  // delta used in solvers
  int sgn = 1; 
  if (delta < 0) sgn = -1;
  delta = sgn * bps * nsamples * 1.0f / SAMPLE_RATE;

  return bpm;

}

void beat2value::set_mix (multi_curve& c, const string& nam) {
  mixer.setup (c, now, delta);
  mixer.name = nam;
}

void beat2value::moused (int dir, double scl) {
  now2 = now + (dir * scl);
  scrub = 2;
}

void beat2value::after_slide () {
  scrub = 0;
}

void beat2value::setstyle (int s) {
  style = s;
  if (style == LOOP) {
    xmin = &_loopmin;
    xmax = &_loopmax;
  } else {
    xmin = &_pongmin;
    xmax = &_pongmax;
  }
}
